#ifndef GRAFPLAYER_H
#define GRAFPLAYER_H

#include "grafTypes.h"
#include "grafTagMulti.h"
#include "ofMain.h"
#include "ofxVectorMath.h"


class grafPlayer
{
    public:
        grafPlayer();
        virtual ~grafPlayer();

		void update( grafTagMulti * myTag );
		void reset();
		void calcPointForTime(float time, grafTagMulti * myTag);
		ofPoint getVelocityForTime(grafTagMulti * myTag);
	
		void drawNowPoint(float scale=1);
		
		ofPoint getCurrentPoint();
        float   getDuration(grafTagMulti * myTag);
        float   getCurrentZDepth( float z_const );
        float   getCurrentTime(){		return timeInRange;  }
        float   getCurrentAngle(){		return nowAngle;	 }
		float   getCurrentDist(){		return nowDist;		 }
        float   getTimeCounter(){		return timeCounter;  }
        int     getCurrentId(){			return nowIndex;     }
		int     getCurrentStroke(){		return nowStroke;    }


		bool                bPaused;
		bool                bDonePlaying;
		bool				bReset;
	
    protected:


	
		float               timeCounter;                // changement du temps pour la lecture
        float               timeOfLastFrame;            // enregistrement de la dernière durée pour calculer al différence de temps
        float               timeInRange;                // temps actuel dans le dessin

		int                 nowIndex;                   // dernier point enregistrer ou dernier point à être dessiner
		int					nowStroke;
		float               nowDist;                    // durée interpolée > distances
        float               nowAngle;                   // durée interpolée > angle
        ofPoint             nowPointForTime;            // durée interpolée > point

    private:
};

#endif // GRAFPLAYER_H
